<!DOCTYPE html>
<html lang="pt-br">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página Inicial</title>

    <style>
        body {
            background: linear-gradient(to right, #a1c4fd, #c2e9fb);
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
        }

        .grid-container {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 20px; /* Aumentei o espaçamento entre os botões para 20px */
            text-align: center;
        }

        .grid-item {
            padding: 20px;
            border-radius: 10px;
            background: linear-gradient(to right, #dcdcdc, #f5f5f5); /* Degrade Cinza */
        }

        .grid-item a {
            text-decoration: none;
            color: #333; /* Cor do texto */
        }
    </style>
    <script>
        function abrirPopup(url) {
            window.open(url, '_blank', 'width=600,height=400');
        }
    </script>
</head>

<body>

    <div class="grid-container">
        <?php

        // Substitua 'INDISPONIVELX.php' pelos nomes reais das suas páginas
        $nomesPaginas = array('/speedtest_adm/ADM.php', '/speedtest_cobranca/COBRANCA.php', '/speedtest_cpd/CPD.php', '/speedtest_imagem/IMAGEM.php', '/speedtest_recepcao_terreo/RECEPCAO_TERREO.php',
                              '/speedtest_sala19/SALA_19.php');

        foreach ($nomesPaginas as $nomePagina) {
            echo '<div class="grid-item">';
            echo '<a href="javascript:abrirPopup(\'' . $nomePagina . '\')">TESTE ' . basename($nomePagina, ".php") . '</a>';
            echo '</div>';
        }
        ?>
    </div>
</body>
</html>
