<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listagem de Arquivos</title>
</head>
<body>

    <h2>Listagem de Arquivos</h2>

    <?php
    $caminho_pasta = '/media/fulltc';
    
    // Verifica se o caminho da pasta é válido
    if (is_dir($caminho_pasta)) {
        
        // Obtém a lista de arquivos na pasta
        $arquivos = scandir($caminho_pasta);
        
        // Remove os diretórios '.' e '..'
        $arquivos = array_diff($arquivos, array('.', '..'));
        
        // Conta o número de arquivos
        $num_arquivos = count($arquivos);
        
        if ($num_arquivos > 10) {
            echo "<p>FALSE_LIMITE</p>";
        } else {
            echo "<p>Existem $num_arquivos arquivos na pasta $caminho_pasta.</p>";
        }
        
        // Caixa de pesquisa
        echo '<form action="" method="post">';
        echo '<label for="search">Procurar arquivos:</label>';
        echo '<input type="text" name="search" id="search">';
        echo '<input type="submit" value="Procurar">';
        echo '</form>';
        
        // Lógica de pesquisa e listagem de arquivos
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $termo_pesquisa = $_POST['search'];
            
            echo '<h3>Resultados da pesquisa:</h3>';
            
            foreach ($arquivos as $arquivo) {
                if ($termo_pesquisa === '' || stripos($arquivo, $termo_pesquisa) !== false) {
                    echo "<p>$arquivo</p>";
                }
            }
        } else {
            // Se nenhum termo de pesquisa fornecido, listar todos os arquivos
            echo '<h3>Listagem de todos os arquivos:</h3>';
            
            foreach ($arquivos as $arquivo) {
                echo "<p>$arquivo</p>";
            }
        }
        
    } else {
        echo "<p>O caminho da pasta não é válido.</p>";
    }
    ?>

</body>
</html>